	clear all
	close all
	clc
	% FRM IIR Case 2 13.7
	Amax = 0.1; Amin = 40; wcT = 14*pi/180; wsT = 15*pi/180;
	Amax1 = Amax/4; % Design margin
	Nstage = 3;
	M1 = 2^(Nstage-1); M2 = M1/2; M3 = M1/2 + 1;
	% Make all filters of odd order in order to allow for lattice filters
	Nm = CA_ORDER_Z(M1*wcT, M1*wsT, Amax1, Amin),	Nm = 9	
 	wc1T = M1*wcT;	ws1T = M1*wsT;	ws2T = pi-ws1T/2; ws3T = pi-3*ws1T/4;
	N2 = CA_ORDER_HB_Z(ws2T, Amin), N2 = 3
	N3 = CA_ORDER_HB_Z(ws3T, Amin), N3 = 5
	
	figure(1), subplot(2,1,1), 			% Model filter
	[G, Z, R_ZEROS, P, WsnewT] = CA_POLES_Z(wc1T, ws1T, Amax1, Amin, Nm);
	wT = linspace(0, pi,2000); 
	H = PZ_2_FREQ_Z(G, Z, P, wT);
	PLOT_MAG_Z_dB(wT, H, pi, 90, 'G')
	subplot(2,1,2)						% Periodic filter
	M1wT = linspace(0, M1*pi,2000);
	Hp = PZ_2_FREQ_Z(G, Z, P, M1wT);
	PLOT_MAG_Z_dB(wT, Hp, pi, 90, 'G_M')
 	figure(2), subplot(2,1,1)				%		 Second stage
	M2wT = linspace(0, M2*pi,2000);
	H2 = PZ_2_FREQ_Z(G, Z, P, M2wT);
	PLOT_MAG_Z_dB(wT, H2, pi, 90, 'H_2')	
	subplot(2,1,2)	 % Third stage
	M3wT = linspace(0, M3*pi,2000);
	H3 = PZ_2_FREQ_Z(G, Z, P, M3wT);
	PLOT_MAG_Z_dB(wT, H3, pi, 90, 'H_3')
	figure(3),subplot('position', [0.1 0.4 0.88 0.5]);	 
	H0 = Hp.*H2.*H3;  
	PLOT_MAG_Z_dB(wT, H0, pi, 90, 'H')
	
